import { Link } from "react-router-dom";
import { MapPin, Phone, Mail, Facebook, Instagram, Youtube } from "lucide-react";
import { TELP, EMAIL } from "@/lib/whatsapp";
import logoGreen from "@/assets/logo-green.png";

const Footer = () => {
  return (
    <footer className="bg-secondary text-secondary-foreground mt-20">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Company Info */}
          <div>
            <img src={logoGreen} alt="PT Medina Wisata Haramain" className="h-12 w-auto mb-4" />
            <p className="text-sm mb-4">
              Penyelenggara perjalanan ibadah umrah dan haji yang terpercaya, berpengalaman, dan berizin resmi.
            </p>
            <div className="flex gap-3">
              <a href="#" className="hover:text-primary transition-colors">
                <Facebook className="w-5 h-5" />
              </a>
              <a href="#" className="hover:text-primary transition-colors">
                <Instagram className="w-5 h-5" />
              </a>
              <a href="#" className="hover:text-primary transition-colors">
                <Youtube className="w-5 h-5" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="font-bold text-lg mb-4">Menu Cepat</h3>
            <ul className="space-y-2">
              <li><Link to="/" className="hover:text-primary transition-colors">Beranda</Link></li>
              <li><Link to="/paket" className="hover:text-primary transition-colors">Paket Umrah</Link></li>
              <li><Link to="/jadwal" className="hover:text-primary transition-colors">Jadwal</Link></li>
              <li><Link to="/artikel" className="hover:text-primary transition-colors">Artikel</Link></li>
              <li><Link to="/tentang" className="hover:text-primary transition-colors">Tentang Kami</Link></li>
            </ul>
          </div>

          {/* Services */}
          <div>
            <h3 className="font-bold text-lg mb-4">Layanan</h3>
            <ul className="space-y-2">
              <li><Link to="/paket" className="hover:text-primary transition-colors">Paket Umrah</Link></li>
              <li><Link to="/paket" className="hover:text-primary transition-colors">Paket Haji</Link></li>
              <li><Link to="/titip-doa" className="hover:text-primary transition-colors">Titip Doa</Link></li>
              <li><Link to="/testimoni" className="hover:text-primary transition-colors">Testimoni</Link></li>
              <li><Link to="/kontak" className="hover:text-primary transition-colors">Hubungi Kami</Link></li>
            </ul>
          </div>

          {/* Contact */}
          <div>
            <h3 className="font-bold text-lg mb-4">Kontak</h3>
            <ul className="space-y-3">
              <li className="flex items-start gap-2">
                <MapPin className="w-5 h-5 flex-shrink-0 mt-0.5" />
                <span className="text-sm">Tasikmalaya, Jawa Barat, Indonesia</span>
              </li>
              <li className="flex items-center gap-2">
                <Phone className="w-5 h-5 flex-shrink-0" />
                <a href={`tel:${TELP.replace(/-/g, '')}`} className="text-sm hover:text-primary transition-colors">{TELP}</a>
              </li>
              <li className="flex items-center gap-2">
                <Mail className="w-5 h-5 flex-shrink-0" />
                <a href={`mailto:${EMAIL}`} className="text-sm hover:text-primary transition-colors">{EMAIL}</a>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-secondary-foreground/20 mt-8 pt-8 text-center text-sm">
          <p>&copy; {new Date().getFullYear()} PT Medina Wisata Haramain. All rights reserved.</p>
        </div>
      </div>
    </footer>
  );
};

export default Footer;
