import { Phone, Mail } from "lucide-react";
import { TELP, EMAIL } from "@/lib/whatsapp";

const Header = () => {
  return (
    <header className="bg-secondary text-secondary-foreground py-2 px-4">
      <div className="container mx-auto flex flex-wrap justify-between items-center text-sm">
        <div className="flex items-center gap-4">
          <a href={`tel:${TELP.replace(/-/g, '')}`} className="flex items-center gap-2 hover:opacity-80 transition-opacity">
            <Phone className="w-4 h-4" />
            <span className="hidden sm:inline">{TELP}</span>
          </a>
          <a href={`mailto:${EMAIL}`} className="flex items-center gap-2 hover:opacity-80 transition-opacity">
            <Mail className="w-4 h-4" />
            <span className="hidden sm:inline">{EMAIL}</span>
          </a>
        </div>
        <div className="text-xs sm:text-sm">
          Terpercaya Sejak 2010 | Berpengalaman Melayani Jamaah
        </div>
      </div>
    </header>
  );
};

export default Header;
