import { MessageCircle } from "lucide-react";
import { Button } from "@/components/ui/button";
import { WA_NUMBER } from "@/lib/whatsapp";

const WhatsAppFloat = () => {
  const handleClick = () => {
    const message = encodeURIComponent("Halo, saya ingin bertanya tentang paket umrah dan haji. Terima kasih.");
    window.open(`https://wa.me/${WA_NUMBER}?text=${message}`, '_blank');
  };

  return (
    <Button
      onClick={handleClick}
      size="icon"
      className="fixed bottom-6 right-6 h-14 w-14 rounded-full shadow-lg hover:shadow-xl transition-all bg-[#25D366] hover:bg-[#20BA5A] text-white z-50 animate-pulse hover:animate-none"
      aria-label="Chat WhatsApp"
    >
      <MessageCircle className="h-7 w-7" />
    </Button>
  );
};

export default WhatsAppFloat;
