import { Card, CardContent, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Badge } from "@/components/ui/badge";
import { Button } from "@/components/ui/button";
import { Link } from "react-router-dom";
import { Calendar, User, ArrowRight } from "lucide-react";

const Artikel = () => {
  const articles = [
    {
      id: 1,
      slug: "tips-persiapan-umrah-pertama-kali",
      title: "10 Tips Persiapan Umrah Pertama Kali",
      excerpt: "Panduan lengkap untuk Anda yang akan berangkat umrah pertama kali. Mulai dari dokumen, perlengkapan, hingga tips ibadah di tanah suci.",
      category: "Panduan",
      author: "Tim Medina Wisata",
      date: "15 Februari 2025",
      readTime: "5 menit"
    },
    {
      id: 2,
      slug: "perbedaan-umrah-dan-haji",
      title: "Memahami Perbedaan Umrah dan Haji",
      excerpt: "Artikel ini menjelaskan perbedaan mendasar antara ibadah umrah dan haji, rukun, wajib, dan waktu pelaksanaannya.",
      category: "Edukasi",
      author: "Ustadz Ahmad",
      date: "12 Februari 2025",
      readTime: "7 menit"
    },
    {
      id: 3,
      slug: "hotel-terbaik-dekat-masjidil-haram",
      title: "Rekomendasi Hotel Terbaik Dekat Masjidil Haram",
      excerpt: "Daftar hotel nyaman dengan jarak dekat dari Masjidil Haram yang kami rekomendasikan untuk para jamaah umrah.",
      category: "Akomodasi",
      author: "Tim Medina Wisata",
      date: "10 Februari 2025",
      readTime: "6 menit"
    },
    {
      id: 4,
      slug: "doa-doa-penting-saat-umrah",
      title: "Kumpulan Doa Penting Saat Umrah",
      excerpt: "Doa-doa yang perlu Anda hafal dan amalkan saat melaksanakan ibadah umrah di Makkah dan Madinah.",
      category: "Doa & Dzikir",
      author: "Ustadz Muhammad",
      date: "8 Februari 2025",
      readTime: "8 menit"
    },
    {
      id: 5,
      slug: "tempat-ziarah-di-madinah",
      title: "Tempat Ziarah Bersejarah di Madinah",
      excerpt: "Panduan lengkap tempat-tempat bersejarah yang wajib dikunjungi saat berada di Madinah Al-Munawwarah.",
      category: "Panduan",
      author: "Tim Medina Wisata",
      date: "5 Februari 2025",
      readTime: "10 menit"
    },
    {
      id: 6,
      slug: "tips-hemat-belanja-oleh-oleh",
      title: "Tips Hemat Belanja Oleh-Oleh dari Arab Saudi",
      excerpt: "Panduan berbelanja oleh-oleh khas Arab Saudi dengan budget terjangkau namun tetap berkualitas.",
      category: "Tips & Trik",
      author: "Hj. Fatimah",
      date: "1 Februari 2025",
      readTime: "5 menit"
    }
  ];

  const getCategoryColor = (category: string) => {
    const colors: any = {
      "Panduan": "bg-blue-500",
      "Edukasi": "bg-green-500",
      "Akomodasi": "bg-purple-500",
      "Doa & Dzikir": "bg-yellow-500",
      "Tips & Trik": "bg-pink-500"
    };
    return colors[category] || "bg-gray-500";
  };

  return (
    <div className="min-h-screen py-12">
      <div className="container mx-auto px-4">
        {/* Header */}
        <div className="text-center mb-12 animate-fade-in">
          <h1 className="text-4xl md:text-5xl font-bold text-foreground mb-4">Artikel & Panduan</h1>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Baca artikel, tips, dan panduan lengkap seputar ibadah umrah dan haji untuk persiapan Anda
          </p>
        </div>

        {/* Articles Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {articles.map((article) => (
            <Card key={article.id} className="overflow-hidden hover:shadow-xl transition-all duration-300 animate-slide-up flex flex-col">
              {/* Image Placeholder */}
              <div className="h-48 bg-gradient-to-br from-secondary to-primary relative">
                <Badge className={`absolute top-4 left-4 ${getCategoryColor(article.category)} text-white`}>
                  {article.category}
                </Badge>
              </div>

              <CardHeader className="flex-grow">
                <CardTitle className="text-xl mb-2 hover:text-primary transition-colors">
                  <Link to={`/artikel/${article.slug}`}>
                    {article.title}
                  </Link>
                </CardTitle>
                <p className="text-muted-foreground text-sm">{article.excerpt}</p>
              </CardHeader>

              <CardContent className="space-y-2 pb-2">
                <div className="flex items-center gap-2 text-sm text-muted-foreground">
                  <User className="w-4 h-4" />
                  <span>{article.author}</span>
                </div>
                <div className="flex items-center justify-between text-sm text-muted-foreground">
                  <div className="flex items-center gap-2">
                    <Calendar className="w-4 h-4" />
                    <span>{article.date}</span>
                  </div>
                  <span>{article.readTime}</span>
                </div>
              </CardContent>

              <CardFooter className="pt-2">
                <Link to={`/artikel/${article.slug}`} className="w-full">
                  <Button variant="outline" className="w-full group">
                    Baca Selengkapnya
                    <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" />
                  </Button>
                </Link>
              </CardFooter>
            </Card>
          ))}
        </div>

        {/* Categories */}
        <div className="mt-16 bg-muted rounded-xl p-8 animate-fade-in">
          <h2 className="text-2xl font-bold text-foreground mb-6 text-center">Kategori Artikel</h2>
          <div className="flex flex-wrap justify-center gap-3">
            {["Panduan", "Edukasi", "Akomodasi", "Doa & Dzikir", "Tips & Trik", "Cerita Jamaah"].map((cat) => (
              <Badge key={cat} variant="outline" className="px-4 py-2 text-sm cursor-pointer hover:bg-primary hover:text-primary-foreground transition-colors">
                {cat}
              </Badge>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default Artikel;
