import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Badge } from "@/components/ui/badge";
import { Link } from "react-router-dom";
import { Clock, Users, Plane, Hotel } from "lucide-react";

const Paket = () => {
  const packages = [
    {
      id: 1,
      name: "Paket Umrah Ekonomis",
      description: "Paket hemat dengan fasilitas lengkap dan nyaman untuk perjalanan ibadah Anda",
      duration: "9 Hari 8 Malam",
      price: "Rp 25.000.000",
      quota: 40,
      available: 15,
      status: "Ready Seat",
      features: ["Hotel Bintang 3", "Makan 3x Sehari", "Visa & Perlengkapan", "Tour Guide Berpengalaman"]
    },
    {
      id: 2,
      name: "Paket Umrah Platinum",
      description: "Paket premium dengan hotel bintang 5 dekat Masjidil Haram dan Masjid Nabawi",
      duration: "12 Hari 11 Malam",
      price: "Rp 45.000.000",
      quota: 30,
      available: 8,
      status: "Ready Seat",
      features: ["Hotel Bintang 5", "Dekat Masjidil Haram", "Buffet Premium", "City Tour Gratis"]
    },
    {
      id: 3,
      name: "Paket Umrah Plus Turki",
      description: "Umrah + Wisata Turki dalam satu perjalanan yang tak terlupakan",
      duration: "16 Hari 15 Malam",
      price: "Rp 55.000.000",
      quota: 25,
      available: 0,
      status: "Full Seat",
      features: ["Umrah + Turki", "Hotel Bintang 4-5", "Wisata Istanbul", "Blue Mosque & Hagia Sophia"]
    },
    {
      id: 4,
      name: "Paket Umrah Reguler",
      description: "Paket standar dengan fasilitas lengkap dan harga terjangkau",
      duration: "10 Hari 9 Malam",
      price: "Rp 28.000.000",
      quota: 45,
      available: 30,
      status: "Ready Seat",
      features: ["Hotel Bintang 3-4", "Transportasi AC", "Ziarah Lengkap", "Manasik Umrah"]
    },
    {
      id: 5,
      name: "Paket Umrah VIP",
      description: "Paket eksklusif dengan pelayanan maksimal dan fasilitas mewah",
      duration: "14 Hari 13 Malam",
      price: "Rp 65.000.000",
      quota: 20,
      available: 12,
      status: "Ready Seat",
      features: ["Hotel Bintang 5+", "View Ka'bah", "Private Transport", "VIP Lounge"]
    },
    {
      id: 6,
      name: "Paket Umrah Ramadhan",
      description: "Paket spesial untuk beribadah di bulan suci Ramadhan",
      duration: "15 Hari 14 Malam",
      price: "Rp 52.000.000",
      quota: 35,
      available: 0,
      status: "Sudah Berangkat",
      features: ["Hotel Bintang 4-5", "Menu Iftar Spesial", "Tarawih di Haramain", "Ziarah Ekstra"]
    }
  ];

  const getStatusColor = (status: string) => {
    switch (status) {
      case "Ready Seat": return "bg-green-500 hover:bg-green-600";
      case "Full Seat": return "bg-red-500 hover:bg-red-600";
      case "Sudah Berangkat": return "bg-yellow-500 hover:bg-yellow-600";
      default: return "bg-gray-500 hover:bg-gray-600";
    }
  };

  return (
    <div className="min-h-screen py-12">
      <div className="container mx-auto px-4">
        {/* Header */}
        <div className="text-center mb-12 animate-fade-in">
          <h1 className="text-4xl md:text-5xl font-bold text-foreground mb-4">Paket Umrah & Haji</h1>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Pilih paket terbaik sesuai kebutuhan dan budget Anda. Semua paket sudah termasuk visa, hotel, transportasi, dan tour guide berpengalaman.
          </p>
        </div>

        {/* Packages Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {packages.map((pkg) => (
            <Card key={pkg.id} className="overflow-hidden hover:shadow-xl transition-all duration-300 animate-slide-up flex flex-col">
              {/* Image Placeholder with Gradient */}
              <div className="h-56 bg-gradient-to-br from-secondary via-primary/80 to-accent relative">
                <div className="absolute inset-0 flex items-center justify-center">
                  <div className="text-white text-center">
                    <Plane className="w-16 h-16 mx-auto mb-2 opacity-80" />
                    <Hotel className="w-12 h-12 mx-auto opacity-60" />
                  </div>
                </div>
                <Badge className={`absolute top-4 right-4 ${getStatusColor(pkg.status)} text-white`}>
                  {pkg.status}
                </Badge>
              </div>

              <CardHeader className="flex-grow">
                <CardTitle className="text-xl mb-2">{pkg.name}</CardTitle>
                <CardDescription>{pkg.description}</CardDescription>
              </CardHeader>

              <CardContent className="space-y-4">
                <div className="space-y-2">
                  <div className="flex items-center gap-2 text-sm">
                    <Clock className="w-4 h-4 text-muted-foreground" />
                    <span>{pkg.duration}</span>
                  </div>
                  <div className="flex items-center gap-2 text-sm">
                    <Users className="w-4 h-4 text-muted-foreground" />
                    <span>Tersedia: {pkg.available} dari {pkg.quota} seat</span>
                  </div>
                </div>

                <div className="border-t pt-4">
                  <ul className="space-y-1 text-sm text-muted-foreground">
                    {pkg.features.map((feature, index) => (
                      <li key={index} className="flex items-center gap-2">
                        <span className="w-1.5 h-1.5 rounded-full bg-primary"></span>
                        {feature}
                      </li>
                    ))}
                  </ul>
                </div>

                <div className="text-3xl font-bold text-primary pt-2">{pkg.price}</div>
              </CardContent>

              <CardFooter className="pt-0">
                <Link to={`/paket/${pkg.id}`} className="w-full">
                  <Button className="w-full bg-secondary hover:bg-secondary/90 text-secondary-foreground">
                    Lihat Detail & Booking
                  </Button>
                </Link>
              </CardFooter>
            </Card>
          ))}
        </div>

        {/* Info Section */}
        <div className="mt-16 bg-muted rounded-xl p-8 animate-fade-in">
          <h2 className="text-2xl font-bold text-foreground mb-4 text-center">Mengapa Memilih Kami?</h2>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
            <div className="text-center">
              <div className="w-16 h-16 bg-primary rounded-full flex items-center justify-center mx-auto mb-4">
                <Users className="w-8 h-8 text-primary-foreground" />
              </div>
              <h3 className="font-bold mb-2">Berpengalaman</h3>
              <p className="text-sm text-muted-foreground">Melayani ribuan jamaah sejak 2010 dengan kepuasan tinggi</p>
            </div>
            <div className="text-center">
              <div className="w-16 h-16 bg-secondary rounded-full flex items-center justify-center mx-auto mb-4">
                <Hotel className="w-8 h-8 text-secondary-foreground" />
              </div>
              <h3 className="font-bold mb-2">Fasilitas Terbaik</h3>
              <p className="text-sm text-muted-foreground">Hotel nyaman dekat Haramain dan makanan berkualitas</p>
            </div>
            <div className="text-center">
              <div className="w-16 h-16 bg-accent rounded-full flex items-center justify-center mx-auto mb-4">
                <Plane className="w-8 h-8 text-accent-foreground" />
              </div>
              <h3 className="font-bold mb-2">Berizin Resmi</h3>
              <p className="text-sm text-muted-foreground">Terdaftar dan berizin resmi Kementerian Agama RI</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Paket;
