import { Card, CardContent } from "@/components/ui/card";
import { Shield, Users, Award, Heart, Plane, CheckCircle } from "lucide-react";

const Tentang = () => {
  const values = [
    {
      icon: <Shield className="w-12 h-12 text-primary" />,
      title: "Terpercaya & Berizin Resmi",
      description: "Terdaftar dan berizin resmi dari Kementerian Agama RI sebagai penyelenggara ibadah umrah dan haji"
    },
    {
      icon: <Users className="w-12 h-12 text-secondary" />,
      title: "Berpengalaman Sejak 2010",
      description: "Lebih dari 15 tahun melayani ribuan jamaah dengan tingkat kepuasan tinggi"
    },
    {
      icon: <Award className="w-12 h-12 text-primary" />,
      title: "Pelayanan Profesional",
      description: "Tim tour guide berpengalaman, muthawif resmi, dan pelayanan 24/7"
    },
    {
      icon: <Heart className="w-12 h-12 text-secondary" />,
      title: "Mengutamakan Kenyamanan",
      description: "Hotel nyaman dekat Haramain, transportasi ber-AC, dan makanan berkualitas"
    }
  ];

  const achievements = [
    { number: "10,000+", label: "Jamaah Dilayani" },
    { number: "15+", label: "Tahun Pengalaman" },
    { number: "4.9/5", label: "Rating Kepuasan" },
    { number: "100%", label: "Kepercayaan" }
  ];

  const facilities = [
    "Hotel Bintang 3-5 dekat Masjidil Haram dan Masjid Nabawi",
    "Transportasi Bus AC selama di Arab Saudi",
    "Makanan bergizi 3x sehari sesuai lidah Indonesia",
    "Tour Guide berbahasa Indonesia dan Muthawif resmi",
    "Visa umrah dan asuransi perjalanan",
    "Perlengkapan umrah lengkap (koper, tas, mukena)",
    "Ziarah lengkap ke tempat bersejarah",
    "Manasik umrah sebelum keberangkatan",
    "Bimbingan ibadah selama di tanah suci",
    "Layanan 24/7 dan customer service responsif"
  ];

  return (
    <div className="min-h-screen py-12">
      <div className="container mx-auto px-4">
        {/* Header */}
        <div className="text-center mb-12 animate-fade-in">
          <h1 className="text-4xl md:text-5xl font-bold text-foreground mb-4">Tentang Kami</h1>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            PT Medina Wisata Haramain - Partner Terpercaya Perjalanan Ibadah Anda
          </p>
        </div>

        {/* Hero Section */}
        <div className="mb-16 animate-fade-in">
          <div className="bg-gradient-to-br from-secondary via-primary/80 to-accent rounded-2xl p-8 md:p-12 text-white text-center">
            <Plane className="w-20 h-20 mx-auto mb-6 opacity-90" />
            <h2 className="text-2xl md:text-3xl font-bold mb-4">
              Melayani Ibadah Umrah & Haji dengan Sepenuh Hati
            </h2>
            <p className="text-lg text-white/90 max-w-3xl mx-auto">
              Sejak 2010, kami telah membantu ribuan jamaah mewujudkan impian mereka untuk beribadah di tanah suci. 
              Dengan pengalaman, profesionalisme, dan dedikasi penuh, kami berkomitmen memberikan pelayanan terbaik untuk setiap jamaah.
            </p>
          </div>
        </div>

        {/* Values */}
        <div className="mb-16">
          <h2 className="text-3xl font-bold text-center mb-12">Mengapa Memilih Kami?</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {values.map((value, index) => (
              <Card key={index} className="text-center hover:shadow-lg transition-all duration-300 animate-slide-up">
                <CardContent className="p-6">
                  <div className="flex justify-center mb-4">
                    {value.icon}
                  </div>
                  <h3 className="font-bold text-lg mb-2">{value.title}</h3>
                  <p className="text-sm text-muted-foreground">{value.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* Achievements */}
        <div className="mb-16 bg-muted rounded-2xl p-8 md:p-12 animate-fade-in">
          <h2 className="text-3xl font-bold text-center mb-12">Pencapaian Kami</h2>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {achievements.map((achievement, index) => (
              <div key={index} className="text-center">
                <div className="text-4xl md:text-5xl font-bold text-primary mb-2">
                  {achievement.number}
                </div>
                <div className="text-muted-foreground">{achievement.label}</div>
              </div>
            ))}
          </div>
        </div>

        {/* Story */}
        <div className="mb-16 animate-fade-in">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
            <div>
              <h2 className="text-3xl font-bold mb-6">Kisah Kami</h2>
              <div className="space-y-4 text-muted-foreground">
                <p>
                  PT Medina Wisata Haramain didirikan pada tahun 2010 dengan visi mulia: membantu umat Islam 
                  mewujudkan impian mereka untuk beribadah di tanah suci Makkah dan Madinah.
                </p>
                <p>
                  Berawal dari kantor kecil di Tasikmalaya, kini kami telah berkembang menjadi salah satu 
                  travel umrah dan haji terpercaya di Indonesia. Dengan izin resmi dari Kementerian Agama RI 
                  dan sertifikasi internasional, kami berkomitmen memberikan pelayanan terbaik.
                </p>
                <p>
                  Lebih dari 10.000 jamaah telah mempercayakan perjalanan ibadah mereka kepada kami. 
                  Kepuasan dan kekhusyukan ibadah jamaah adalah prioritas utama kami.
                </p>
                <p className="font-semibold text-foreground">
                  &quot;Kami tidak hanya mengantarkan Anda ke tanah suci, tetapi juga menemani setiap langkah 
                  perjalanan spiritual Anda dengan penuh dedikasi.&quot;
                </p>
              </div>
            </div>
            <div className="h-[400px] bg-gradient-to-br from-secondary to-primary rounded-2xl flex items-center justify-center">
              <div className="text-white text-center p-8">
                <Award className="w-24 h-24 mx-auto mb-4 opacity-80" />
                <h3 className="text-2xl font-bold mb-2">Terdaftar & Berizin Resmi</h3>
                <p className="text-white/90">Kementerian Agama RI</p>
              </div>
            </div>
          </div>
        </div>

        {/* Facilities */}
        <div className="mb-16 animate-fade-in">
          <h2 className="text-3xl font-bold text-center mb-12">Fasilitas & Layanan</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
            {facilities.map((facility, index) => (
              <div key={index} className="flex items-start gap-3 p-4 bg-muted rounded-lg hover:bg-muted/80 transition-colors">
                <CheckCircle className="w-5 h-5 text-green-600 flex-shrink-0 mt-0.5" />
                <span>{facility}</span>
              </div>
            ))}
          </div>
        </div>

        {/* Legalitas */}
        <Card className="bg-gradient-to-br from-primary to-secondary text-white animate-fade-in">
          <CardContent className="p-8 md:p-12">
            <h2 className="text-3xl font-bold text-center mb-8">Legalitas & Sertifikasi</h2>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
              <div>
                <Shield className="w-12 h-12 mx-auto mb-3" />
                <h3 className="font-bold mb-2">PPIU Resmi</h3>
                <p className="text-sm text-white/90">Terdaftar Kemenag RI</p>
              </div>
              <div>
                <Award className="w-12 h-12 mx-auto mb-3" />
                <h3 className="font-bold mb-2">ISO Certified</h3>
                <p className="text-sm text-white/90">Standar Internasional</p>
              </div>
              <div>
                <Users className="w-12 h-12 mx-auto mb-3" />
                <h3 className="font-bold mb-2">ASITA Member</h3>
                <p className="text-sm text-white/90">Asosiasi Travel Indonesia</p>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* CTA */}
        <div className="mt-16 text-center animate-fade-in">
          <h2 className="text-3xl font-bold mb-4">Siap Berangkat Bersama Kami?</h2>
          <p className="text-lg text-muted-foreground mb-6">
            Wujudkan impian ibadah Anda di tanah suci bersama PT Medina Wisata Haramain
          </p>
          <div className="flex gap-4 justify-center flex-wrap">
            <a href="/paket">
              <button className="bg-primary hover:bg-primary/90 text-primary-foreground px-8 py-3 rounded-lg font-semibold transition-all">
                Lihat Paket Umrah
              </button>
            </a>
            <a href="/kontak">
              <button className="bg-secondary hover:bg-secondary/90 text-secondary-foreground px-8 py-3 rounded-lg font-semibold transition-all">
                Hubungi Kami
              </button>
            </a>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Tentang;
