import { Card, CardContent, CardHeader } from "@/components/ui/card";
import { Star } from "lucide-react";

const Testimoni = () => {
  const testimonials = [
    {
      id: 1,
      name: "Hj. Siti Aminah",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Siti",
      rating: 5,
      date: "Januari 2025",
      paket: "Paket Umrah Platinum",
      message: "Alhamdulillah, perjalanan umrah sangat lancar dan nyaman. Pelayanan tour guide sangat membantu, hotel dekat dengan Masjidil Haram. Makanan enak dan sesuai lidah Indonesia. Terima kasih Medina Wisata Haramain! Sangat direkomendasikan."
    },
    {
      id: 2,
      name: "H. Ahmad Fauzi",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Ahmad",
      rating: 5,
      date: "Desember 2024",
      paket: "Paket Umrah VIP",
      message: "Hotel bintang 5 dengan view Ka'bah sangat luar biasa. Makanan buffet premium, transportasi sangat nyaman. Tour guide profesional dan sabar dalam membimbing. Harga sebanding dengan fasilitas yang didapat. Jazakumullahu khairan."
    },
    {
      id: 3,
      name: "Hj. Nur Hasanah",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Nur",
      rating: 5,
      date: "November 2024",
      paket: "Paket Umrah Ekonomis",
      message: "Ini umrah kedua saya dengan Medina Wisata. Pelayanan tetap memuaskan meskipun paket ekonomis. Hotel bersih, makan teratur, dan guide berpengalaman. Harga sangat terjangkau. Insya Allah umrah lagi tahun depan dengan Medina Wisata."
    },
    {
      id: 4,
      name: "H. Budi Santoso",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Budi",
      rating: 5,
      date: "Oktober 2024",
      paket: "Paket Umrah Reguler",
      message: "Pengalaman umrah yang sangat berkesan. Semua sudah diatur dengan baik, kami tinggal fokus beribadah. Ziarah lengkap ke semua tempat bersejarah. Tour guide menjelaskan dengan detail dan penuh hikmah. Barakallahu fiikum."
    },
    {
      id: 5,
      name: "Hj. Aisyah Rahmawati",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Aisyah",
      rating: 5,
      date: "September 2024",
      paket: "Paket Umrah Plus Turki",
      message: "Paket umrah plus Turki sangat worth it! Setelah umrah di Makkah dan Madinah, kami wisata ke Istanbul, Blue Mosque, dan Hagia Sophia. Hotel bagus, tour guide ramah. Liburan sekaligus ibadah. Recommended banget!"
    },
    {
      id: 6,
      name: "H. Faris Abdullah",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Faris",
      rating: 5,
      date: "Agustus 2024",
      paket: "Paket Umrah Ramadhan",
      message: "Umrah Ramadhan bersama Medina Wisata sangat istimewa. Menu iftar yang beragam, shalat tarawih di Masjidil Haram dan Masjid Nabawi. Pengalaman yang tak terlupakan. Tim Medina Wisata sangat amanah dan profesional."
    },
    {
      id: 7,
      name: "Hj. Dewi Kusuma",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Dewi",
      rating: 5,
      date: "Juli 2024",
      paket: "Paket Umrah Platinum",
      message: "Sebagai ibu dengan anak kecil, saya sangat terbantu dengan pelayanan dari Medina Wisata. Tour guide sabar, hotel nyaman untuk anak-anak, dan transportasi aman. Anak-anak senang dan saya tenang. Terima kasih banyak!"
    },
    {
      id: 8,
      name: "H. Yusuf Hidayat",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Yusuf",
      rating: 5,
      date: "Juni 2024",
      paket: "Paket Umrah Ekonomis",
      message: "Meskipun paket ekonomis, pelayanannya tidak ekonomis! Semua fasilitas lengkap, hotel bersih, makan enak, dan yang paling penting adalah bimbingan ibadah yang baik. Sangat puas dan akan merekomendasikan ke keluarga dan teman."
    },
    {
      id: 9,
      name: "Hj. Mariam",
      photo: "https://api.dicebear.com/7.x/avataaars/svg?seed=Mariam",
      rating: 5,
      date: "Mei 2024",
      paket: "Paket Umrah VIP",
      message: "Pelayanan VIP yang benar-benar VIP. Dari penjemputan, airport lounge, hotel mewah, sampai private transport. Tour guide very helpful dan caring. Pengalaman umrah yang sangat nyaman dan khusyuk. Alhamdulillah."
    }
  ];

  return (
    <div className="min-h-screen py-12">
      <div className="container mx-auto px-4">
        {/* Header */}
        <div className="text-center mb-12 animate-fade-in">
          <h1 className="text-4xl md:text-5xl font-bold text-foreground mb-4">Testimoni Jamaah</h1>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto">
            Pengalaman nyata dari ribuan jamaah yang telah menunaikan ibadah umrah dan haji bersama PT Medina Wisata Haramain
          </p>
        </div>

        {/* Stats */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12 animate-fade-in">
          <Card className="text-center p-6 bg-gradient-to-br from-secondary to-primary text-white">
            <div className="text-4xl font-bold mb-2">10,000+</div>
            <div className="text-lg">Jamaah Dilayani</div>
          </Card>
          <Card className="text-center p-6 bg-gradient-to-br from-primary to-accent text-primary-foreground">
            <div className="text-4xl font-bold mb-2">4.9/5.0</div>
            <div className="text-lg flex items-center justify-center gap-1">
              Rating Kepuasan <Star className="w-5 h-5 fill-current" />
            </div>
          </Card>
          <Card className="text-center p-6 bg-gradient-to-br from-accent to-secondary text-accent-foreground">
            <div className="text-4xl font-bold mb-2">15 Tahun</div>
            <div className="text-lg">Pengalaman Melayani</div>
          </Card>
        </div>

        {/* Testimonials Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
          {testimonials.map((testimonial) => (
            <Card key={testimonial.id} className="hover:shadow-xl transition-all duration-300 animate-slide-up">
              <CardHeader>
                <div className="flex items-center gap-4">
                  <img
                    src={testimonial.photo}
                    alt={testimonial.name}
                    className="w-16 h-16 rounded-full border-2 border-primary"
                  />
                  <div className="flex-grow">
                    <h3 className="font-bold text-lg">{testimonial.name}</h3>
                    <div className="flex gap-1 mt-1">
                      {[...Array(testimonial.rating)].map((_, i) => (
                        <Star key={i} className="w-4 h-4 fill-yellow-400 text-yellow-400" />
                      ))}
                    </div>
                  </div>
                </div>
                <div className="mt-2 text-sm text-muted-foreground">
                  <div>{testimonial.paket}</div>
                  <div>{testimonial.date}</div>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-muted-foreground italic leading-relaxed">
                  &quot;{testimonial.message}&quot;
                </p>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* CTA */}
        <div className="mt-16 bg-gradient-to-r from-secondary to-primary rounded-xl p-8 text-center text-white animate-fade-in">
          <h2 className="text-2xl md:text-3xl font-bold mb-4">Ingin Menjadi Bagian dari Testimoni Kami?</h2>
          <p className="text-lg mb-6 text-white/90">
            Bergabunglah dengan ribuan jamaah yang telah merasakan pengalaman ibadah terbaik bersama kami
          </p>
          <div className="flex gap-4 justify-center flex-wrap">
            <a href="/paket">
              <button className="bg-white text-secondary hover:bg-white/90 px-8 py-3 rounded-lg font-semibold transition-all">
                Lihat Paket Umrah
              </button>
            </a>
            <a href="/kontak">
              <button className="bg-white/10 backdrop-blur-sm text-white border-2 border-white hover:bg-white hover:text-secondary px-8 py-3 rounded-lg font-semibold transition-all">
                Konsultasi Gratis
              </button>
            </a>
          </div>
        </div>
      </div>
    </div>
  );
};

export default Testimoni;
